/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import javax.swing.JApplet;
import javax.swing.JFrame;

public class Gravy
extends JApplet {
    Object lock;
    double previousPointerAngle;
    double pointerAngle;
    Thread t;
    Polygon pointer = new Polygon(new int[]{0, -2, 0, 2, 0}, new int[]{5, 0, -40, 0, 5}, 5);
    int cx;
    int cy;
    String fontName;
    int fontSize;
    Font font;
    FontMetrics fm;
    int nticks;
    int tickZero;
    int tickWidth;
    String[] label;
    Color pcolor;
    Color dcolor;
    Color lcolor;
    Color wcolor;
    Color background;
    int nwarn;
    int warning;
    int freq;
    boolean parametersRead;
    boolean stopped;
    boolean mustDrawFace;
    AffineTransform scaleXform;
    boolean calculateScaleXform;

    void readParameters() {
        try {
            this.background = new Color(Integer.parseInt(this.getParameter("Background"), 16));
        }
        catch (Exception exception) {
            this.background = this.getBackground();
        }
        try {
            this.pcolor = new Color(Integer.parseInt(this.getParameter("PointerColor"), 16));
        }
        catch (Exception exception) {
            this.pcolor = Color.black;
        }
        try {
            this.lcolor = new Color(Integer.parseInt(this.getParameter("LabelColor"), 16));
        }
        catch (Exception exception) {
            this.lcolor = Color.black;
        }
        try {
            this.dcolor = new Color(Integer.parseInt(this.getParameter("DialColor"), 16));
        }
        catch (Exception exception) {
            this.dcolor = Color.black;
        }
        try {
            this.wcolor = new Color(Integer.parseInt(this.getParameter("WarningColor"), 16));
        }
        catch (Exception exception) {
            this.wcolor = null;
        }
        try {
            this.nticks = Integer.parseInt(this.getParameter("Ticks"));
        }
        catch (Exception exception) {
            this.nticks = 7;
        }
        try {
            this.nwarn = Integer.parseInt(this.getParameter("WarningTicks"));
        }
        catch (Exception exception) {
            this.nwarn = 1;
        }
        try {
            int n = Integer.parseInt(this.getParameter("NumLabels"));
            this.label = new String[n];
            int n2 = 1;
            while (n2 <= n) {
                this.label[n2 - 1] = this.getParameter("Label" + n2);
                ++n2;
            }
        }
        catch (Exception exception) {
            this.label = new String[]{"Gravy", "Pressure"};
        }
        try {
            this.fontName = this.getParameter("FontName");
            if (this.fontName == null) {
                this.fontName = "SansSerif";
            }
        }
        catch (Exception exception) {
            this.fontName = "SansSerif";
        }
        try {
            this.fontSize = Integer.parseInt(this.getParameter("FontSize"));
        }
        catch (Exception exception) {
            this.fontSize = 8;
        }
        try {
            this.freq = Integer.parseInt(this.getParameter("UpdateFreq"));
        }
        catch (Exception exception) {
            this.freq = 33;
        }
        try {
            this.tickZero = Integer.parseInt(this.getParameter("TickZero"));
        }
        catch (Exception exception) {
            this.tickZero = 0;
        }
        try {
            this.tickWidth = Integer.parseInt(this.getParameter("TickWidth"));
        }
        catch (Exception exception) {
            this.tickWidth = 10;
        }
        this.parametersRead = true;
    }

    public void init() {
        this.parametersRead = false;
        this.pointerAngle = -2.356194490192345;
        this.t = null;
        this.stopped = true;
        this.lock = new Object();
        this.tickZero = 0;
        this.tickWidth = 10;
        if (!this.parametersRead) {
            this.readParameters();
        }
        this.font = new Font(this.fontName, 0, this.fontSize);
        this.fm = null;
        this.setBackground(this.background);
        this.scaleXform = AffineTransform.getScaleInstance(1.0, 1.0);
        this.calculateScaleXform = true;
        this.mustDrawFace = true;
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Gravy.this.calculateScaleXform = true;
            }
        });
        if (this.t == null) {
            this.t = new Thread(new Animate());
            this.t.start();
        }
    }

    public void drawFace(Graphics2D graphics2D) {
        int n;
        double d = -3.9269908169872414;
        int n2 = (int)(270.0 / (double)(this.nticks - 1)) * this.nwarn;
        graphics2D.clearRect(-50, -50, 100, 100);
        graphics2D.setFont(this.font);
        if (this.fm == null) {
            this.fm = graphics2D.getFontMetrics();
        }
        if (this.wcolor != null) {
            graphics2D.setColor(this.wcolor);
            graphics2D.fillArc(-33, -33, 66, 66, -45, n2);
            graphics2D.setColor(this.background);
            graphics2D.fillArc(-29, -29, 58, 58, -135, -270);
        }
        graphics2D.setColor(this.dcolor);
        graphics2D.drawArc(-33, -33, 66, 66, -135, -270);
        graphics2D.drawArc(-29, -29, 58, 58, -135, -270);
        int n3 = 0;
        while (n3 < this.nticks) {
            n = (int)(29.0 * Math.cos(d));
            int n4 = (int)(29.0 * Math.sin(d));
            int n5 = (int)(33.0 * Math.cos(d));
            int n6 = (int)(33.0 * Math.sin(d));
            int n7 = (int)(43.0 * Math.cos(d));
            int n8 = (int)(43.0 * Math.sin(d));
            String string = Integer.toString(this.tickZero + n3 * this.tickWidth);
            d += 4.71238898038469 / (double)(this.nticks - 1);
            graphics2D.setColor(this.dcolor);
            graphics2D.drawLine(n, n4, n5, n6);
            graphics2D.setColor(this.lcolor);
            graphics2D.drawString(string, n7 - this.fm.stringWidth(string) / 2, n8 + this.fm.getHeight() / 4);
            ++n3;
        }
        n = 0;
        while (n < this.label.length) {
            graphics2D.drawString(this.label[n], -this.fm.stringWidth(this.label[n]) / 2, -14 + n * this.fm.getHeight() / 2);
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = this.pointerAngle;
        if (this.calculateScaleXform) {
            Dimension dimension = this.getSize();
            this.scaleXform = AffineTransform.getScaleInstance((double)dimension.width / 100.0, (double)dimension.height / 100.0);
            this.scaleXform.translate(50.0, 50.0);
            this.calculateScaleXform = false;
        }
        graphics2D.setTransform(this.scaleXform);
        if (this.mustDrawFace) {
            this.drawFace(graphics2D);
        }
        graphics2D.setColor(this.background);
        graphics2D.setXORMode(this.pcolor);
        if (!this.mustDrawFace) {
            graphics2D.rotate(this.previousPointerAngle);
            graphics2D.fillPolygon(this.pointer);
            graphics2D.rotate(-this.previousPointerAngle);
        }
        graphics2D.rotate(d);
        graphics2D.fillPolygon(this.pointer);
        graphics2D.rotate(-d);
        graphics2D.setPaintMode();
        this.previousPointerAngle = d;
        this.mustDrawFace = true;
    }

    boolean updateAngle() {
        if (this.pointerAngle != this.previousPointerAngle) {
            return false;
        }
        this.pointerAngle = Math.random() < 0.5 ? (this.pointerAngle += 0.12566370614359174 * Math.random()) : (this.pointerAngle -= 0.12566370614359174 * Math.random());
        if (this.pointerAngle > 2.356194490192345) {
            this.pointerAngle = 2.356194490192345;
        }
        if (this.pointerAngle < -2.356194490192345) {
            this.pointerAngle = -2.356194490192345;
        }
        return true;
    }

    public void start() {
        Object object = this.lock;
        synchronized (object) {
            this.stopped = false;
            this.mustDrawFace = true;
            this.lock.notifyAll();
        }
    }

    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.stopped = true;
            this.lock.notifyAll();
        }
    }

    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            if (this.t != null) {
                this.t = null;
            }
            this.stopped = true;
            this.lock.notifyAll();
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Gravy");
        Gravy gravy = new Gravy();
        int n = 100;
        int n2 = 100;
        if (stringArray.length > 0) {
            n = Integer.parseInt(stringArray[0]);
        }
        if (stringArray.length > 1) {
            n2 = Integer.parseInt(stringArray[1]);
        }
        if (n < 0) {
            n = 100;
        }
        if (n2 < 0) {
            n2 = 100;
        }
        ((Component)jFrame).setVisible(true);
        Insets insets = jFrame.getInsets();
        ((Component)jFrame).setSize(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
        ((Component)jFrame).setLocation(10, 10);
        gravy.background = Color.white;
        gravy.init();
        jFrame.setContentPane(gravy);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.validate();
        gravy.start();
    }

    class Animate
    implements Runnable {
        Animate() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Thread thread = Thread.currentThread();
            Object object = Gravy.this.lock;
            synchronized (object) {
                while (Gravy.this.t == thread) {
                    try {
                        Gravy.this.lock.wait(Gravy.this.stopped ? 0L : (long)Gravy.this.freq);
                        if (!Gravy.this.updateAngle()) continue;
                        Gravy.this.mustDrawFace = false;
                        Gravy.this.repaint();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return;
            }
        }
    }
}

