/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JFrame;

public class Deadline
extends Gravy {
    final long ONE_HOUR = 3600000L;
    final long ONE_DAY = 86400000L;
    final long ONE_WEEK = 604800000L;
    final long ONE_MONTH = 2419200000L;
    GregorianCalendar deadline;
    TimeScale[] scales;
    TimeScale scale;
    DateFormat[] formats;

    protected boolean setScale() {
        long l = this.deadline.getTime().getTime() - System.currentTimeMillis();
        TimeScale timeScale = this.scale;
        int n = 0;
        while (n < this.scales.length) {
            if (l < this.scales[n].tickUnit * (long)this.scales[n].numUnits) {
                this.scale = this.scales[n];
                break;
            }
            ++n;
        }
        if (this.scale == null) {
            this.scale = this.scales[this.scales.length - 1];
        }
        if (this.scale != timeScale) {
            this.label[this.label.length - 1] = this.scale.label;
            this.nticks = this.scale.numTicks;
            this.tickZero = this.scale.tickZero;
            this.tickWidth = this.scale.tickWidth;
        }
        return this.scale != timeScale;
    }

    protected GregorianCalendar parseDate(String string) {
        int n = 0;
        while (n < this.formats.length) {
            try {
                Date date = this.formats[n].parse(string);
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(date);
                return gregorianCalendar;
            }
            catch (ParseException parseException) {
                ++n;
            }
        }
        return new GregorianCalendar();
    }

    void readParameters() {
        super.readParameters();
        try {
            this.deadline = this.parseDate(this.getParameter("deadline"));
        }
        catch (Exception exception) {
            this.deadline = new GregorianCalendar();
        }
    }

    public void init() {
        this.scales = new TimeScale[]{new TimeScale(3600000L, 24, 24, 7, -4, "Hours"), new TimeScale(86400000L, 7, 7, 8, -1, "Days"), new TimeScale(604800000L, 4, 4, 5, -1, "Weeks"), new TimeScale(2419200000L, 12, 12, 5, -3, "Months")};
        this.scale = null;
        this.formats = new DateFormat[]{DateFormat.getDateTimeInstance(1, 1), DateFormat.getDateTimeInstance(1, 2), DateFormat.getDateTimeInstance(2, 2), DateFormat.getDateTimeInstance(3, 2), DateFormat.getDateTimeInstance(1, 3), DateFormat.getDateTimeInstance(2, 3), DateFormat.getDateTimeInstance(3, 3), DateFormat.getDateInstance(1), DateFormat.getDateInstance(2), DateFormat.getDateInstance(3)};
        int n = 0;
        while (n < this.formats.length) {
            this.formats[n].setLenient(true);
            ++n;
        }
        super.init();
        String[] stringArray = new String[this.label.length + 2];
        System.arraycopy(this.label, 0, stringArray, 0, this.label.length);
        stringArray[stringArray.length - 2] = "";
        stringArray[stringArray.length - 1] = null;
        this.label = stringArray;
        this.setScale();
        this.freq = 1000;
    }

    synchronized boolean updateAngle() {
        if (this.previousPointerAngle != this.pointerAngle) {
            return false;
        }
        boolean bl = this.setScale();
        long l = this.deadline.getTime().getTime() - System.currentTimeMillis();
        double d = (double)l / (double)this.scale.tickUnit;
        if (d > 0.0 && d < (double)this.scale.numUnits) {
            this.pointerAngle = 2.356194490192345 - d / (double)this.scale.numUnits * Math.abs(4.71238898038469);
        } else {
            double d2 = this.pointerAngle = d < 0.0 ? 2.356194490192345 : -2.356194490192345;
        }
        if (bl) {
            this.mustDrawFace = true;
            this.repaint();
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Gravy");
        Deadline deadline = new Deadline();
        int n = 100;
        int n2 = 100;
        if (stringArray.length > 0) {
            n = Integer.parseInt(stringArray[0]);
        }
        if (stringArray.length > 1) {
            n2 = Integer.parseInt(stringArray[1]);
        }
        if (n < 0) {
            n = 100;
        }
        if (n2 < 0) {
            n2 = 100;
        }
        ((Component)jFrame).setVisible(true);
        Insets insets = jFrame.getInsets();
        ((Component)jFrame).setSize(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
        ((Component)jFrame).setLocation(10, 10);
        deadline.background = Color.white;
        deadline.init();
        if (stringArray.length > 2) {
            deadline.deadline = deadline.parseDate(stringArray[2]);
        }
        jFrame.setContentPane(deadline);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.validate();
        deadline.start();
    }

    class TimeScale {
        long tickUnit;
        int numUnits;
        int tickZero;
        int numTicks;
        int tickWidth;
        String label;

        public TimeScale(long l, int n, int n2, int n3, int n4, String string) {
            this.tickUnit = l;
            this.numUnits = n;
            this.tickZero = n2;
            this.numTicks = n3;
            this.tickWidth = n4;
            this.label = string;
        }
    }
}

