#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#else
#define O_RDONLY 	0x0000
#ifdef HAVE_FLOCK
#define LOCK_SH         0x01
#define LOCK_UN         0x08
int flock(int, int);
#endif
#endif


#include <ctype.h>
#include <sys/param.h>

int main(int argc, char *argv[])
{
    int f;
    int num;
    char *c;
    char fname[MAXPATHLEN];

    if (argc > 2) {
	fprintf(stderr, "Usage %s <fortune file>\n", argv[0]);
	exit(1);
    }
    fname[0] = '\0';
    if (argc != 2) {
	c = getenv("FORTUNE");
	if ( c ) strncpy(fname, c, MAXPATHLEN);
	else {
	    fprintf(stderr,"%s : Cannot determine fortune file\n", argv[0]);
	    exit(20);
	}
    }
    else
	strncpy(fname, argv[1], MAXPATHLEN);
    if (fname[0] == '\0') {
	fprintf(stderr, "%s: Can't find default fortune file\n", argv[0]);
	exit(1);
    }
    c = getenv("FORTUNE_SUFFIX");
    strncat(fname, ((c != NULL) ? c : ".ind"), MAXPATHLEN - strlen(fname));
    f = open(fname, O_RDONLY);
    read(f, &num, sizeof(int));
    printf("%d\n", num);
    exit(0);
}
