#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#else
int read(int d, void *buf, int nbytes);
#endif
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#else
#define O_RDONLY 	0x0000
#ifdef HAVE_FLOCK
#define LOCK_SH         0x01
#define LOCK_UN         0x08
int flock(int, int);
#endif
#endif

#include <sys/param.h>
#include <ctype.h>
#ifdef RANDOM_IN_MATH
#include <math.h>
#endif


#if !defined(HAVE_RANDOM) && defined(HAVE_RAND)
#define random() rand()
#define srandom(x) srand(x)
#endif

#ifndef RANDOM_DECLARED
void srandom(int);
long random();
#endif

void
fatal(char *s)
{
    fprintf(stderr, "Fatal error in fortune\n");
    fprintf(stderr, s);
    exit(0);
}


int main(int argc, char *argv[])
{

    int i;
    int x;
    int f, index;
    int nocr = 0;
    char fname[MAXPATHLEN];
    char iname[MAXPATHLEN];
    char isuffix[MAXPATHLEN];
    char *buffer = NULL;
    struct {
	int start, end;
    }      entry;
    int num = 1;
    int wait = 0;
    int sig = 0;
    int pipe = 0;
    int total, seed;
    char *sigs;
    short c;

    fname[0] = iname[0] = isuffix[0] = '\0';

    for (i = 1; i < argc; i++)
	if (isdigit(*argv[i]))
	    num = atoi(argv[i]);
	else if (*argv[i] == '-')
	    switch (argv[i][1]) {
		case 'n':
		    nocr = 1;
		    break;
		case 'w':
		    if (argc == i + 1)
			fatal("No parameter given with -w\n");
		    else
			wait = atoi(argv[++i]);
		    break;
		    /* Note the case fall through */
		case 's':
		    sig = 1;
		case 'p':
		    pipe = 1;
		    break;
		case 'i':
		    if (argc == i + 1)
			fatal("No parameter given with -i\n");
		    else
			strncpy(isuffix, argv[++i], MAXPATHLEN);
		    break;

	    }
	else
	    strncpy(fname, argv[i], MAXPATHLEN);
    if (*fname == '\0') {
	if ( getenv("FORTUNE") != NULL ) 
	    strncpy(fname, getenv("FORTUNE"), MAXPATHLEN);
	else
	    fatal("error - no default fortune file\n");
    }
    if (*isuffix == '\0') {
	if ( getenv("FORTUNE_SUFFIX") != NULL ) 
	    strncpy(isuffix, getenv("FORTUNE_SUFFIX"), MAXPATHLEN);
	else
	    strncpy(isuffix, ".ind", MAXPATHLEN);
    }
    strncpy(iname, fname, MAXPATHLEN);
    strncat(iname, isuffix, MAXPATHLEN - strlen(iname));
    if ((f = open(fname, O_RDONLY)) == -1)
	fatal("Can't open fortune file\n");
    if ((index = open(iname, O_RDONLY)) == -1)
	fatal("Can't open index file\n");
#ifdef HAVE_FLOCK
    if (flock(index, LOCK_SH) == -1)
	fatal("Error obtaining lock\n");
#endif
    if (read(index, &total, sizeof(int)) != sizeof(int))
	fatal("Can't read index file\n");
    seed = (int) time(0);
    srandom(seed);
    if (sig || pipe)
	while ((c = getchar()) != EOF)
	    printf("%c", c);
    for (i = 0; i < num; i++) {
	x = (int) (random() % total);
	if (lseek(index, x * sizeof(int) + sizeof(int), SEEK_SET) == -1)
	    fatal("Seek error on index\n");;
	if (read(index, (char *) &entry, sizeof(entry)) == -1)
	    fatal("Read error on index\n");
	if (lseek(f, entry.start, SEEK_SET) == -1)
	    fatal("Seek error on fortune\n");
	buffer = (char *) malloc(entry.end - entry.start + 1);
	buffer[read(f, buffer, entry.end - entry.start)] = '\0';
	printf("%s", buffer);
	if (buffer != NULL) {
	    free(buffer);
	    buffer = NULL;
	}
	if (!nocr)
	    printf("\n");
    }
    if (wait)
	sleep((unsigned) wait);
#ifdef HAVE_FLOCK
    flock(index, LOCK_UN);
#endif
    close(f);
    close(index);
    if (sig) {
	if ( (sigs = getenv("FSIG")) ) printf("%s\n", sigs);
    }
    exit(0);
}
