#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#else
int read(int d, void *buf, int nbytes);
#endif
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#else
#define O_RDONLY 	0x0000
#ifdef HAVE_FLOCK
#define LOCK_SH         0x01
#define LOCK_UN         0x08
int flock(int, int);
#endif
#endif

#include <ctype.h>
#include <sys/param.h>

#define BUFLEN 1024


int
readln(char *buf, int file)
{
    int i = 0;
    char c;

    do {
	if (read(file, &c, sizeof(char)) == 1)
	    buf[i++] = c;
	else
	    break;
    } while (c != '\n' && i < BUFLEN);
    buf[i] = '\0';
    return i;
}

int main(int argc, char *argv[])
{

    int f1, f2;
    char fname[MAXPATHLEN];
    char iname[MAXPATHLEN];
    char buf[BUFLEN];
    int len = 0;
    int linelen = 0;
    int done = 0;
    int total = 0;
    char *c;

    if (argc > 2) {
	fprintf(stderr, "Usage : %s filename\n", argv[0]);
	exit(0);
    }
    c = (argc > 1) ? argv[1] : getenv("FORTUNE");
    if ( c != NULL )
	strncpy(fname, (argc > 1) ? argv[1] : getenv("FORTUNE"), MAXPATHLEN);
    else {
	fprintf(stderr,"Can't determine file to index\n");
	exit(20);
    }
    strncpy(iname, fname, MAXPATHLEN);
    c = getenv("FORTUNE_SUFFIX");
    strncat(iname, ((c != NULL) ? c : ".ind"), MAXPATHLEN);
    if ((f1 = open(fname, O_RDONLY)) == -1) {
	fprintf(stderr, "%s : Error opening %s\n", argv[0], fname);
	exit(1);
    }
    if ((f2 = open(iname, O_CREAT | O_TRUNC | O_RDWR, 0640)) == -1) {
	fprintf(stderr, "%s : Error creating index(%s)\n", argv[0], iname);
	exit(1);
    }
#ifdef HAVE_FLOCK
    if (flock(f2, LOCK_EX) == -1) {
	fprintf(stderr, "%s : Index in use\n", argv[0]);
	exit(1);
    }
#endif

    write(f2, (char *) &len, sizeof(int));
    write(f2, (char *) &len, sizeof(int));
    len = readln(buf, f1);
    while (!done)
	if ((linelen = readln(buf, f1)))
	    if (isspace(*buf) || *buf == '\n')
		len += linelen;
	    else {
		write(f2, (char *) &len, sizeof(int));
		len += linelen;
		total++;
	    }
	else {
	    write(f2, (char *) &len, sizeof(int));
	    done++;
	    total++;
	}
    lseek(f2, 0, SEEK_SET);
    write(f2, (char *) &total, sizeof(int));
    printf("%d quotes processed\n", total);
#ifdef HAVE_FLOCK
    flock(f2, LOCK_UN);
#endif
    close(f1);
    close(f2);
    exit(0);
}
